/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.BinaryOutBlockConnector;
import DE.siemens.ad.logo.model.BlockNameChangedListener;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.BlockPropertyChangeEvent;
import DE.siemens.ad.logo.model.BlockPropertyChangeListener;
import DE.siemens.ad.logo.model.EqualsCheck;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.HardwareChangedListener;
import DE.siemens.ad.logo.model.HardwareFactory;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.InBlockConnectorEnumeration;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.LogoHardwareFactory;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnectorEnumeration;
import DE.siemens.ad.logo.model.ParameterInBlockConnector;
import DE.siemens.ad.logo.model.SimulationParameter;
import DE.siemens.ad.logo.model.Visitable;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.model.visitor.build.Visitor;
import DE.siemens.ad.logo.util.CodeBlock;
import DE.siemens.ad.logo.util.DifferenceTableModel;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import DE.siemens.ad.logo.util.Logger.LocalizedInfo;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.udf.UDFBlock;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class Block
implements Cloneable,
Serializable,
Storable,
Visitable,
EqualsCheck,
LocalizedInfo {
    static final long serialVersionUID = 2646728338369430351L;
    private int blockSerializedDataVersion = 1;
    protected transient ArrayList fPropertyChangeListeners;
    protected Hardware fHardware;
    protected WiringDiagram fWiringDiagram;
    protected String fBlockNumberPrefix = "B";
    protected int fBlockNumber = 0;
    protected InBlockConnector[] fInConnectors;
    public OutBlockConnector[] fOutConnectors;
    protected transient String fToolTipText = null;
    protected transient Vector fBlockNameChangedListeners;
    protected SimulationParameter fSimulationParameter;
    protected String fUserDefinedName;
    protected static int stackdeep = 0;

    public Block() {
        this.initInConnectors();
        this.initOutConnectors();
        this.initBlockNumber();
    }

    protected Block(WiringDiagram wiringDiagram) {
        this.fWiringDiagram = wiringDiagram;
        if (wiringDiagram != null) {
            this.fHardware = wiringDiagram.getHardware();
        }
        this.initInConnectors();
        this.initOutConnectors();
        if (wiringDiagram != null) {
            HardwareChangedEvent hardwareChangedEvent = new HardwareChangedEvent(this, null, wiringDiagram.getHardware());
            this.hardwareChanged(hardwareChangedEvent);
        }
        this.initBlockNumber();
    }

    public Object acceptVisitor(Visitor visitor) {
        CodeBlock c = new CodeBlock(visitor, "visit");
        c.addParameter(this);
        Object returnValue = null;
        try {
            returnValue = c.execMethod();
        }
        catch (NoSuchMethodException e) {
            Exception ex = c.getInternalException();
            if (ex instanceof NoSuchMethodException) {
                System.out.println("Methode visit(" + this + ") in '" + visitor + "' nicht definiert");
            } else {
                System.out.println("Exception in visit(" + this + ") in " + visitor);
                ex.printStackTrace();
            }
            throw new RuntimeException("Visit of " + this + " failed");
        }
        return returnValue;
    }

    public void addBlockNameChangedListener(BlockNameChangedListener l) {
        this.getBlockNameChangedListeners().addElement(l);
    }

    public synchronized void addPropertyChangeListener(BlockPropertyChangeListener listener) {
        if (!this.getPropertyChangeListeners().contains(listener)) {
            this.getPropertyChangeListeners().add(listener);
        }
    }

    public boolean canCreateInstance(int opcode, int blockNumber) {
        try {
            return this.getOpcode() == opcode;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public void changeNumber(int newNumber) throws IllegalArgumentException {
        if (this.getNumber() == newNumber) {
            return;
        }
        this.getWiringDiagram().changeNumber(this.getNumberType(), this.getNumber(), newNumber);
        this.fBlockNumber = newNumber;
    }

    public int compareBlockNumberTo(Block otherBlock) {
        int result = this.getNumberPrefix().compareTo(otherBlock.getNumberPrefix());
        if (result == 0) {
            result = this.getNumber() - otherBlock.getNumber();
        }
        return result;
    }

    public boolean compareTo(Block otherBlock, DifferenceTableModel differences) {
        boolean result = true;
        if (this.getClass() != otherBlock.getClass()) {
            String[] str = new String[]{Language.getString("compare.differentBlockType", "Different Blocktype"), this.getLocalizedName(true), otherBlock.getLocalizedName(true)};
            Object[] o = new Object[]{this, otherBlock};
            differences.add(str, o);
            return false;
        }
        if (this.getNumber() != otherBlock.getNumber()) {
            String[] str = new String[]{Language.getString("compare.differentBlockNumber", "Different Blocknumber"), this.getNumberString(), otherBlock.getNumberString()};
            Object[] o = new Object[]{this, otherBlock};
            differences.add(str, o);
            return false;
        }
        String thisName = this.getUserDefinedName();
        thisName = thisName == null ? "" : Util.trimRight(thisName);
        String otherName = otherBlock.getUserDefinedName();
        if (!thisName.equals(otherName = otherName == null ? "" : Util.trimRight(otherName))) {
            String[] str = new String[]{Language.getString("global.blockname", "Blockname"), thisName, otherName};
            Object[] o = new Object[]{this, otherBlock};
            differences.add(str, o);
            return false;
        }
        return result;
    }

    public boolean isAvailable(Hardware hw, List errorList) {
        int inConnectorCount;
        Block block = ((Logo)hw).getSubstitutionBlock(this);
        boolean result = true;
        if (!(block instanceof UDFBlock) && !hw.isBlockNameAvailable(block.getName())) {
            errorList.add(new ErrorInfo(this, "error.convert.block.unknownBlock", hw));
            return false;
        }
        int numberType = block.getNumberType();
        if (numberType >= 0 && block.getNumber() > hw.getMaxResource(numberType)) {
            errorList.add(new ErrorInfo(this, "error.convert.block.numberTooBig", hw));
            result &= false;
        }
        if (!hw.supports("4BaseBlockInputs") && (inConnectorCount = this.getInConnectorCount()) > 0) {
            InBlockConnector[] connectors = this.getInConnectors();
            for (int i = 0; i < connectors.length; ++i) {
                if (connectors[i].isAvailable(hw, errorList)) continue;
                result &= false;
                break;
            }
        }
        if (this.getParameter() != null && !this.getParameter().isAvailable(hw, errorList)) {
            result &= false;
        }
        if (!hw.supports("userBlockName") && this.getUserDefinedName() != null && this.getUserDefinedName().length() > 0) {
            errorList.add(new ErrorInfo(this, "error.convert.block.userDefinedName", hw));
            result &= false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireBlockPropertyChangeEvent(BlockPropertyChangeEvent event) {
        ArrayList listeners;
        Block block = this;
        synchronized (block) {
            listeners = (ArrayList)this.getPropertyChangeListeners().clone();
        }
        for (int i = 0; i < listeners.size(); ++i) {
            BlockPropertyChangeListener listener = (BlockPropertyChangeListener)listeners.get(i);
            listener.blockPropertyChange(event);
        }
    }

    public static Block createInstanceForName(String className, WiringDiagram wiringDiagram) throws IOException {
        if (className.indexOf(".") == -1) {
            className = "DE.siemens.ad.logo.model.block." + className;
        }
        CodeBlock block = null;
        try {
            block = new CodeBlock(className);
            block.addParameter(wiringDiagram);
            return (Block)block.execConstructor();
        }
        catch (NoSuchMethodException e) {
            Exception ie = block.getInternalException();
            ie.printStackTrace();
            if (ie instanceof InvocationTargetException) {
                ((InvocationTargetException)ie).getTargetException().printStackTrace();
            }
            ie = block.getInternalException();
            ie.printStackTrace();
            if (ie instanceof InvocationTargetException) {
                ((InvocationTargetException)ie).getTargetException().printStackTrace();
            }
            throw new IOException("Class " + className + " does not seem to have one-arg constructor");
        }
    }

    public static Block createTemplate(String className) throws ExceptionAlreadyHandledException {
        Block result = null;
        CodeBlock code = null;
        try {
            if (className.endsWith(".UDFBlock")) {
                className = "DE.siemens.ad.udf.UDFBlock";
            }
            result = (Block)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            Exception ie = code.getInternalException();
            ie.printStackTrace();
            if (ie instanceof InvocationTargetException) {
                ((InvocationTargetException)ie).getTargetException().printStackTrace();
            }
            throw new ExceptionAlreadyHandledException();
        }
        return result;
    }

    public Block deepCopy() {
        Block clonedBlock = null;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(200);
            StorableOutput so = new StorableOutput(outputStream);
            so.writeStorable(this);
            so.close();
            byte[] clipboard = outputStream.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(clipboard);
            StorableInput si = new StorableInput(inputStream);
            clonedBlock = (Block)si.readStorable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return clonedBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireBlockNameChangedEvent() {
        if (!this.getBlockNameChangedListeners().isEmpty()) {
            Vector l;
            Block block = this;
            synchronized (block) {
                l = (Vector)this.fBlockNameChangedListeners.clone();
            }
            for (int i = 0; i < l.size(); ++i) {
                BlockNameChangedListener bncl = (BlockNameChangedListener)l.elementAt(i);
                bncl.blockNameChanged(this);
            }
            if (this.getWiringDiagram() != null) {
                this.getWiringDiagram().setModified(true);
            }
        }
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        this.setHardware((Hardware)hardwareChangedEvent.getNewValue());
        this.fireBlockNameChangedEvent();
    }

    public void hardwareChangeFinished(HardwareChangedEvent hardwareChangedEvent) {
    }

    public int getOutConnectorValueType() {
        return 0;
    }

    public double calculateAnalogValue() {
        System.out.println("LOGOError: calculateAnalogValue() not defined in class: " + this.getClassName());
        throw new UnsupportedOperationException("calculateAnalogValue() not defined in class: " + this.getClassName());
    }

    public double getAnalogValue() {
        System.out.println("LOGOError: getAnalogValue() not defined in class: " + this.getClassName());
        throw new UnsupportedOperationException("getAnalogValue() not defined in class: " + this.getClassName());
    }

    public boolean getBinaryValue() {
        if (this.getOutConnectorCount() > 0) {
            return ((BinaryOutBlockConnector)this.getOutConnector(0)).getBinaryValue();
        }
        return false;
    }

    protected boolean calculateBinaryValue() {
        System.out.println("LOGOError: calculateBinaryValue() not defined in class: " + this.getClassName());
        return false;
    }

    public Vector getViaInConnectorConnectedBlocks() {
        Vector<Block> connectedBlocks = new Vector<Block>();
        int inBlockConnectorCount = this.getInConnectorCount();
        OutBlockConnectorEnumeration outBlockConnectors = null;
        for (int i = 0; i < inBlockConnectorCount; ++i) {
            outBlockConnectors = this.getInConnector(i).getLinkedConnectors();
            while (outBlockConnectors.hasMoreElements()) {
                connectedBlocks.add(outBlockConnectors.nextElement().getOwner());
            }
        }
        return connectedBlocks;
    }

    public Vector getViaOutConnectorConnectedBlocks() {
        Vector<Block> connectedBlocks = new Vector<Block>();
        int outBlockConnectorCount = this.getOutConnectorCount();
        InBlockConnectorEnumeration inBlockConnectors = null;
        for (int i = 0; i < outBlockConnectorCount; ++i) {
            inBlockConnectors = this.getOutConnector(i).getLinkedConnectors();
            while (inBlockConnectors.hasMoreElements()) {
                connectedBlocks.add(inBlockConnectors.nextElement().getOwner());
            }
        }
        return connectedBlocks;
    }

    public Vector getConnectedBlocks() {
        Vector connectedBlocks = this.getViaOutConnectorConnectedBlocks();
        connectedBlocks.addAll(this.getViaInConnectorConnectedBlocks());
        return connectedBlocks;
    }

    protected Vector getBlockNameChangedListeners() {
        if (this.fBlockNameChangedListeners == null) {
            this.fBlockNameChangedListeners = new Vector();
        }
        return this.fBlockNameChangedListeners;
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    protected abstract int getDefaultOrder();

    protected ArrayList getPropertyChangeListeners() {
        if (this.fPropertyChangeListeners == null) {
            this.fPropertyChangeListeners = new ArrayList();
        }
        return this.fPropertyChangeListeners;
    }

    public String getIconName() {
        return this.getName() + "Icon.gif";
    }

    public InBlockConnector getInConnector(int index) throws ArrayIndexOutOfBoundsException {
        return this.getInConnectors()[index];
    }

    public int getInConnectorCount() {
        if (this.fInConnectors == null) {
            return 0;
        }
        return this.fInConnectors.length;
    }

    public int getInConnectorPosition(InBlockConnector connector) {
        int position = -1;
        for (int i = 0; i < this.fInConnectors.length; ++i) {
            if (this.fInConnectors[i] == null || this.fInConnectors[i] != connector) continue;
            position = i;
            break;
        }
        return position;
    }

    public int getOutConnectorPosition(OutBlockConnector connector) {
        int position = -1;
        try {
            if (connector == this.fOutConnectors[0]) {
                position = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return position;
    }

    public InBlockConnector[] getInConnectors() {
        return this.fInConnectors;
    }

    public String getLanguageKey() {
        return new StringBuffer("block.").append(this.getName()).toString();
    }

    public String getLocalizedName(boolean withNumber) {
        String blockType = Language.getString(this.getLanguageKey(), this.getName());
        if (withNumber) {
            StringBuffer result = new StringBuffer(this.getNumberString());
            result.append(" [").append(blockType).append("]");
            return result.toString();
        }
        return blockType.toString();
    }

    public Vector getMaxPath(Hashtable visitedBlocks) {
        Vector<Block> maxPath;
        if (visitedBlocks.containsKey(this)) {
            return (Vector)visitedBlocks.get(this);
        }
        Vector<Block> retPath = maxPath = new Vector<Block>();
        int nrOfInputs = this.getInConnectorCount();
        for (int i = 0; i < nrOfInputs; ++i) {
            Block block = this.getInConnector(i).getLinkedBlock();
            if (block != null) {
                if (block.isRightTerminal()) {
                    retPath = new Vector();
                    retPath.add(block);
                } else {
                    retPath = new Vector(block.getMaxPath(visitedBlocks));
                }
            }
            if (retPath.size() <= maxPath.size()) continue;
            maxPath = retPath;
        }
        maxPath.add(this);
        visitedBlocks.put(this, maxPath);
        return maxPath;
    }

    public int[] getMemoryResources(Hardware hardware) {
        int[] arr = new int[HardwareFactory.getInstance().getResourceNames().length];
        return arr;
    }

    public String getName() {
        String name = "";
        String className = this.getClass().getName();
        StringTokenizer st = new StringTokenizer(className, ".");
        while (st.hasMoreTokens()) {
            name = st.nextToken();
        }
        name = name.substring(0, name.length() - 5);
        return name;
    }

    public String getHelpIDString() {
        return "block." + this.getName();
    }

    public String getUserDefinedName() {
        return this.fUserDefinedName;
    }

    public void setUserDefinedName(String newName) {
        this.fUserDefinedName = newName;
        this.fireBlockNameChangedEvent();
    }

    public int getNumber() {
        return this.fBlockNumber;
    }

    public String getNumberPrefix() {
        if (this.fBlockNumberPrefix == null) {
            if (this.fWiringDiagram == null) {
                return "B";
            }
            this.fBlockNumberPrefix = this.fWiringDiagram.getProgrammingLanguage().getBlockNumberPrefix(this);
            return this.fBlockNumberPrefix;
        }
        return this.fBlockNumberPrefix;
    }

    public String getNumberString() {
        return this.getNumberString(this.getNumber());
    }

    public String getNumberString(int blockNumber) {
        StringBuffer buffer = new StringBuffer(this.getNumberPrefix());
        if (blockNumber > 0) {
            String string = "00" + Integer.toString(blockNumber);
            if (this.getHardware() != null) {
                int maxBlocks = this.getHardware().getMaxResource(0);
                buffer.append(string.substring(string.length() - Integer.toString(maxBlocks).length()));
            } else {
                buffer.append(string.substring(2));
            }
        }
        if (this.isUserDefinedNameAvailable()) {
            buffer.append(" ").append(this.getUserDefinedName());
        }
        return buffer.toString();
    }

    public int getNumberType() {
        return -1;
    }

    public int getOpcode() throws RuntimeException {
        try {
            return this.getOpcode(this.getWiringDiagram().getHardware(), this.getNumber());
        }
        catch (NullPointerException e) {
            throw new IllegalStateException(this.getLocalizedName(true) + ": getOpcode() kann ohne Hardware nicht bestimmt werden.");
        }
    }

    public int getOpcode(Hardware hw, int blockNr) throws IllegalArgumentException, RuntimeException {
        throw new RuntimeException(this.getClass() + ">>getOpcode() not implemented");
    }

    protected int getOrder() {
        String name = this.getName() + "Order";
        return LogoProperties.instance().getIntProperty(name, this.getDefaultOrder());
    }

    public OutBlockConnector getOutConnector(int i) {
        return this.getOutConnectors()[i];
    }

    public int getOutConnectorCount() {
        return this.getOutConnectors().length;
    }

    public OutBlockConnector[] getOutConnectors() {
        if (this.fOutConnectors == null) {
            this.fOutConnectors = new OutBlockConnector[0];
        }
        return this.fOutConnectors;
    }

    public BlockParameter getParameter() {
        InBlockConnector[] connector = this.getInConnectors();
        if (connector != null) {
            for (int i = 0; i < connector.length; ++i) {
                if (!(connector[i] instanceof ParameterInBlockConnector)) continue;
                return ((ParameterInBlockConnector)connector[i]).getLinkedParameter();
            }
        } else {
            return null;
        }
        return null;
    }

    public int getResourceIndex() {
        throw new UnsupportedOperationException();
    }

    public SimulationParameter getSimulationParameter() {
        return this.fSimulationParameter;
    }

    public String getToolTipText() {
        if (this.fToolTipText == null) {
            this.fToolTipText = Language.getString(this.getLanguageKey(), this.getName());
        }
        return this.fToolTipText;
    }

    public abstract String getType();

    public WiringDiagram getWiringDiagram() {
        return this.fWiringDiagram;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
    }

    protected void initBlockNumber() {
        if (this.fWiringDiagram != null) {
            this.fBlockNumber = this.fWiringDiagram.getFreeNumber(this.getNumberType());
        }
    }

    protected void initInConnectors() {
        this.fInConnectors = null;
    }

    protected void initOutConnectors() {
        this.fOutConnectors = new OutBlockConnector[1];
        this.fOutConnectors[0] = new BinaryOutBlockConnector(this);
    }

    public abstract boolean isLeftTerminal();

    public boolean isResourceAvailable(WiringDiagram wd) {
        boolean result = true;
        int[] needResources = ((Logo)wd.getHardware()).getSubstitutionBlock(this).getMemoryResources(wd.getHardware());
        int[] freeResources = wd.getFreeResources();
        for (int i = 0; i < needResources.length; ++i) {
            if (needResources[i] <= freeResources[i]) continue;
            return false;
        }
        return result;
    }

    public boolean isResourceAvailable(WiringDiagram wd, ArrayList errorList) {
        boolean result = true;
        int[] needResources = ((Logo)wd.getHardware()).getSubstitutionBlock(this).getMemoryResources(wd.getHardware());
        int[] freeResources = wd.getFreeResources();
        for (int i = 0; i < needResources.length; ++i) {
            if (needResources[i] <= freeResources[i]) continue;
            String s = Language.getString("hardware." + LogoHardwareFactory.getInstance().getResourceNames()[i], "Resource");
            s = Language.getString("error.notAvailable", "% not available", s);
            errorList.add(new ErrorInfo(this, s, wd.getHardware()));
            return false;
        }
        return result;
    }

    public boolean isRightTerminal() {
        return this instanceof OutputBlock;
    }

    public boolean isCompatibel(Block other) {
        InBlockConnector[] inputs = this.getInConnectors();
        InBlockConnector[] otherInputs = other.getInConnectors();
        if (inputs == null && otherInputs == null) {
            return true;
        }
        if (inputs == null || otherInputs == null) {
            return false;
        }
        if (inputs.length != otherInputs.length) {
            return false;
        }
        for (int i = 0; i < otherInputs.length; ++i) {
            if (inputs[i].getSignalType() == otherInputs[i].getSignalType()) continue;
            return false;
        }
        return true;
    }

    public boolean isEqual(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Block otherBlock = (Block)other;
        if (this.getNumber() != otherBlock.getNumber()) {
            return false;
        }
        return this.getNumberPrefix().equals(otherBlock.getNumberPrefix());
    }

    public boolean isTerminal() {
        return this.isLeftTerminal() || this.isRightTerminal();
    }

    public boolean postDelete(WiringDiagram wd) {
        return false;
    }

    public String preInsert(WiringDiagram wd) {
        if (this.getOutConnectorCount() > 0) {
            boolean visibility = wd.isRightTerminal(this);
            this.getOutConnector(0).setVisible(!visibility);
            this.getOutConnector(0).setConnectable(!visibility);
        }
        return null;
    }

    public void read(StorableInput dr) throws IOException {
        int i;
        this.fBlockNumber = dr.readInt();
        this.fBlockNumberPrefix = dr.readString();
        int count = dr.readInt();
        if (count > 0) {
            this.fOutConnectors = new OutBlockConnector[count];
            for (i = 0; i < count; ++i) {
                this.fOutConnectors[i] = (OutBlockConnector)dr.readStorable();
            }
        }
        if ((count = dr.readInt()) > 0) {
            this.fInConnectors = new InBlockConnector[count];
            for (i = 0; i < count; ++i) {
                this.fInConnectors[i] = (InBlockConnector)dr.readStorable();
            }
        }
        this.fUserDefinedName = dr.readString();
        String hwName = dr.readString();
        this.fHardware = hwName.equals("null") ? null : HardwareFactory.getInstance().createInstance(hwName);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        ++stackdeep;
        s.defaultReadObject();
        if (this.fWiringDiagram != null) {
            boolean visibility = !this.fWiringDiagram.isRightTerminal(this);
            for (int i = 0; i < this.getOutConnectorCount(); ++i) {
                this.getOutConnector(i).setVisible(visibility);
                this.getOutConnector(i).setConnectable(visibility);
            }
        }
        --stackdeep;
    }

    public void removeAllListener() {
        this.getPropertyChangeListeners().clear();
        this.getBlockNameChangedListeners().removeAllElements();
    }

    public void removeBlockNameChangedListener(BlockNameChangedListener l) {
        this.getBlockNameChangedListeners().removeElement(l);
    }

    public synchronized void removeHardwareChangedListener(HardwareChangedListener listener) {
        this.getPropertyChangeListeners().remove(listener);
    }

    public void setNumber(int newNumber) {
        this.fBlockNumber = newNumber;
        this.fireBlockNameChangedEvent();
    }

    public void setNumberString(String newNumber) throws IllegalArgumentException {
        try {
            int end;
            int start = 0;
            while (!Character.isDigit(newNumber.charAt(start))) {
                ++start;
            }
            for (end = start; newNumber.length() > end && Character.isDigit(newNumber.charAt(end)); ++end) {
            }
            this.changeNumber(Integer.parseInt(newNumber.substring(start, end)));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.getMessage());
        }
        this.fireBlockNameChangedEvent();
    }

    public void setWiringDiagram(WiringDiagram newWiringDiagram) {
        Hardware oldHardware = this.fHardware;
        this.fWiringDiagram = newWiringDiagram;
        if (newWiringDiagram != null) {
            Hardware newHardware = newWiringDiagram.getHardware();
            this.setHardware(newHardware);
            if (oldHardware == null || !oldHardware.getName().equals(newHardware.getName())) {
                this.hardwareChanged(new HardwareChangedEvent(this, oldHardware, newHardware));
            }
        }
    }

    public static Block[] sort(Block[] array) {
        for (int i = 1; i < array.length; ++i) {
            int j;
            boolean found = false;
            for (j = i - 1; 0 <= j; --j) {
                if (array[i].getOrder() < array[j].getOrder()) {
                    continue;
                }
                found = true;
                break;
            }
            j = found ? ++j : 0;
            Block o = array[i];
            for (int k = i - 1; k >= j; --k) {
                array[k + 1] = array[k];
            }
            array[j] = o;
        }
        return array;
    }

    public static Vector[] sort(Vector[] values) {
        int i;
        Block[] arr = null;
        Object[] srcArr = null;
        Block[] blockTypeArr = null;
        int size = values.length;
        Vector[] result = new Vector[size];
        int dst = 0;
        blockTypeArr = new Block[size];
        for (i = 0; i < size; ++i) {
            blockTypeArr[i] = (Block)values[i].elementAt(0);
        }
        Block.sort(blockTypeArr);
        for (i = 0; i < size; ++i) {
            srcArr = new Block[values[i].size()];
            values[i].copyInto(srcArr);
            arr = new Block[values[i].size() - 1];
            System.arraycopy(srcArr, 1, arr, 0, arr.length);
            Block.sort(arr);
            values[i].removeAllElements();
            values[i].addElement(srcArr[0]);
            for (int j = 0; j < arr.length; ++j) {
                values[i].addElement(arr[j]);
            }
            for (dst = 0; dst < blockTypeArr.length && blockTypeArr[dst] != srcArr[0]; ++dst) {
            }
            result[dst] = values[i];
        }
        return result;
    }

    public static final Block[] sort(Vector blocks) {
        Block[] arr = new Block[blocks.size()];
        blocks.toArray(arr);
        return Block.sort(arr);
    }

    public static void sortForBlockNumber(Block[] blocks) {
        for (int i = 1; i < blocks.length; ++i) {
            int j;
            boolean found = false;
            for (j = i - 1; 0 <= j; --j) {
                if (0 > blocks[i].compareBlockNumberTo(blocks[j])) {
                    continue;
                }
                found = true;
                break;
            }
            j = found ? ++j : 0;
            Block b = blocks[i];
            for (int k = i - 1; k >= j; --k) {
                blocks[k + 1] = blocks[k];
            }
            blocks[j] = b;
        }
    }

    public static void sortForOnlyBlockNumber(Block[] blocks, boolean order) {
        for (int i = 1; i < blocks.length; ++i) {
            int j;
            boolean found = false;
            for (j = i - 1; 0 <= j; --j) {
                int numberCompare = blocks[i].getNumber() - blocks[j].getNumber();
                int prefixCompare = blocks[i].getNumberPrefix().compareTo(blocks[j].getNumberPrefix());
                if (order && 0 > numberCompare || !order && 0 < numberCompare || numberCompare == 0 && prefixCompare < 0) {
                    continue;
                }
                found = true;
                break;
            }
            j = found ? ++j : 0;
            Block b = blocks[i];
            for (int k = i - 1; k >= j; --k) {
                blocks[k + 1] = blocks[k];
            }
            blocks[j] = b;
        }
    }

    public static void sortForBlockNumberPrefix(Block[] blocks) {
        Comparator prefixComparator = new Comparator(){

            public int compare(Object block1, Object block2) {
                return ((Block)block1).getNumberPrefix().compareTo(((Block)block2).getNumberPrefix());
            }
        };
        Arrays.sort(blocks, prefixComparator);
    }

    public static void sortForBlockNumberPrefixDesc(Block[] blocks) {
        Comparator prefixComparator = new Comparator(){

            public int compare(Object block1, Object block2) {
                return -((Block)block1).getNumberPrefix().compareTo(((Block)block2).getNumberPrefix());
            }
        };
        Arrays.sort(blocks, prefixComparator);
    }

    public String toString() {
        return this.getLocalizedName(false);
    }

    public void write(StorableOutput dw) {
        int i;
        dw.writeInt(this.fBlockNumber);
        dw.writeString(this.getNumberPrefix());
        if (this.fOutConnectors != null) {
            dw.writeInt(this.fOutConnectors.length);
            for (i = 0; i < this.fOutConnectors.length; ++i) {
                dw.writeStorable(this.fOutConnectors[i]);
            }
        } else {
            dw.writeInt(0);
        }
        if (this.fInConnectors != null) {
            dw.writeInt(this.fInConnectors.length);
            for (i = 0; i < this.fInConnectors.length; ++i) {
                dw.writeStorable(this.fInConnectors[i]);
            }
        } else {
            dw.writeInt(0);
        }
        if (this.fUserDefinedName == null) {
            this.fUserDefinedName = "";
        }
        dw.writeString(this.fUserDefinedName);
        if (this.fHardware != null) {
            dw.writeString(this.fHardware.getName());
        } else {
            dw.writeString("null");
        }
    }

    public void setNumberPrefix(String prefix) {
        this.fBlockNumberPrefix = prefix;
        this.fireBlockNameChangedEvent();
    }

    public boolean supportsUserDefinedName() {
        return false;
    }

    public boolean isUserDefinedNameAvailable() {
        return this.getUserDefinedName() != null && this.getUserDefinedName().length() > 0;
    }

    public Hardware getHardware() {
        if (this.fHardware == null && this.fWiringDiagram != null) {
            this.fHardware = this.fWiringDiagram.getHardware();
        }
        return this.fHardware;
    }

    public void setHardware(Hardware hardware) {
        this.fHardware = hardware;
    }

    public void deleteReferences(HashMap dict) {
    }

    public List getAllInConnectors() {
        if (this.fInConnectors == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(this.fInConnectors);
    }

    public String getNumberPostfix() {
        return "";
    }

    public void invalidateOutConnectors() {
        for (int i = 0; i < this.fOutConnectors.length; ++i) {
            this.fOutConnectors[i].setDataInvalid();
        }
    }
}

